﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LINQ_to_DataSet__SQL_Server_
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'telefonyDataSet.ListaOsob' table. You can move, or remove it, as needed.
            this.listaOsobTableAdapter.Fill(this.telefonyDataSet.ListaOsob);

        }

        private void button1_Click(object sender, EventArgs e)
        {
            //tam
            var listaOsobPelnoletnich = from osoba in telefonyDataSet.ListaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko, osoba.Imię
                                        select osoba;

            //z powrotem
            DataTable dt = listaOsobPelnoletnich.CopyToDataTable();
            dt.TableName = "ListaOsobPelnoletnich";

            string s = "Kolumny tabeli:\n";
            foreach (var kolumna in dt.Columns) s += kolumna.ToString() + "\n";
            MessageBox.Show(s);

            //z powrotem
            telefonyDataSet.Tables.Add(dt);

            s = "Nazwy tabel:\n";
            foreach (var tabela in telefonyDataSet.Tables) s += tabela.ToString() + "\n";
            MessageBox.Show(s);
        }

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //tam
            var listaOsobPelnoletnich = from osoba in telefonyDataSet.ListaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko, osoba.Imię
                                        select new Osoba
                                        {
                                            Id = osoba.Id,
                                            Imię = osoba.Imię,
                                            Nazwisko = osoba.Nazwisko,
                                            NumerTelefonu = osoba.NumerTelefonu,
                                            Wiek = osoba.Wiek
                                        };

            //z powrotem

            //projektowanie tabeli
            DataTable dt = new DataTable("ListaOsobPelnoletnich");
            Osoba first = listaOsobPelnoletnich.First();
            DataColumn dcId = new DataColumn("Id");
            dcId.AllowDBNull = false;
            dcId.DataType = first.Id.GetType();
            DataColumn dcImię = new DataColumn("Imię");
            dcImię.DataType = first.Imię.GetType();
            DataColumn dcNazwisko = new DataColumn("Nazwisko");
            dcNazwisko.DataType = first.Nazwisko.GetType();
            DataColumn dcNumerTelefonu = new DataColumn("NumerTelefonu");
            dcNumerTelefonu.DataType = first.NumerTelefonu.GetType();
            DataColumn dcWiek = new DataColumn("Wiek");
            dcWiek.DataType = first.Wiek.GetType();

            dt.Columns.Add(dcId);
            dt.Columns.Add(dcImię);
            dt.Columns.Add(dcNazwisko);
            dt.Columns.Add(dcNumerTelefonu);
            dt.Columns.Add(dcWiek);

            //zapelnianie tabeli danymi
            foreach (Osoba osoba in listaOsobPelnoletnich)
            {
                DataRow dr = dt.NewRow();
                dr["Id"] = osoba.Id;
                dr["Imię"] = osoba.Imię;
                dr["Nazwisko"] = osoba.Nazwisko;
                dr["NumerTelefonu"] = osoba.NumerTelefonu;
                dr["Wiek"] = osoba.Wiek;
                dt.Rows.Add(dr);
            }

            string s = "Kolumny tabeli:\n";
            foreach (var kolumna in dt.Columns) s += kolumna.ToString() + "\n";
            MessageBox.Show(s);

            telefonyDataSet.Tables.Add(dt);

            s = "Nazwy tabel:\n";
            foreach (var tabela in telefonyDataSet.Tables) s += tabela.ToString() + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            DataTable dt = telefonyDataSet.ListaOsob;
            int iloscOsobPelnoletnich = dt.AsEnumerable().Count(dr => dr.Field<int>("Wiek") > 18);

            double sredniWiek = dt.AsEnumerable().Average(osoba => osoba.Field<int>("Wiek"));

            var listaKobiet = from osoba in telefonyDataSet.ListaOsob
                              where osoba.Imię.EndsWith("a")
                              orderby -osoba.Nazwisko.Length
                              select new
                              {
                                  Id = osoba.Id,
                                  Imię = osoba.Imię,
                                  Nazwisko = osoba.Nazwisko,
                                  NumerTelefonu = osoba.NumerTelefonu,
                                  Wiek = osoba.Wiek
                              };
        }
    }
}
